%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for educational purposes associated with the book
%
%
%

function [R,THETA,PHI] = car2Sph(x,y,z)
if (x==0)&&(y==0)&&(z==0)
    R = 0;
    THETA = 0;
    PHI = 0;
else
    R = sqrt(x^2 + y^2 + z^2);
    THETA = acos(z/R);
    if x>=0
        PHI = asin(y/sqrt(x^2 + y^2));
    else
        PHI = pi - asin(y/sqrt(x^2 + y^2));
    end;
end;